/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.base;

import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import team.creative.creativecore.common.util.math.base.Facing;

public enum Axis {
    X{

        @Override
        public double get(double x, double y, double z) {
            return x;
        }

        @Override
        public float get(float x, float y, float z) {
            return x;
        }

        @Override
        public int get(int x, int y, int z) {
            return x;
        }

        @Override
        public <T> T get(T x, T y, T z) {
            return x;
        }

        @Override
        public Axis one() {
            return Y;
        }

        @Override
        public Axis two() {
            return Z;
        }

        @Override
        public Facing facing(boolean positive) {
            return positive ? Facing.EAST : Facing.WEST;
        }

        @Override
        public Direction.Axis toVanilla() {
            return Direction.Axis.X;
        }
    }
    ,
    Y{

        @Override
        public double get(double x, double y, double z) {
            return y;
        }

        @Override
        public float get(float x, float y, float z) {
            return y;
        }

        @Override
        public int get(int x, int y, int z) {
            return y;
        }

        @Override
        public <T> T get(T x, T y, T z) {
            return y;
        }

        @Override
        public Axis one() {
            return Z;
        }

        @Override
        public Axis two() {
            return X;
        }

        @Override
        public Facing facing(boolean positive) {
            return positive ? Facing.UP : Facing.DOWN;
        }

        @Override
        public Direction.Axis toVanilla() {
            return Direction.Axis.Y;
        }
    }
    ,
    Z{

        @Override
        public double get(double x, double y, double z) {
            return z;
        }

        @Override
        public float get(float x, float y, float z) {
            return z;
        }

        @Override
        public int get(int x, int y, int z) {
            return z;
        }

        @Override
        public <T> T get(T x, T y, T z) {
            return z;
        }

        @Override
        public Axis one() {
            return X;
        }

        @Override
        public Axis two() {
            return Y;
        }

        @Override
        public Facing facing(boolean positive) {
            return positive ? Facing.SOUTH : Facing.NORTH;
        }

        @Override
        public Direction.Axis toVanilla() {
            return Direction.Axis.Z;
        }
    };


    public static Axis get(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return X;
            }
            case Y: {
                return Y;
            }
            case Z: {
                return Z;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Axis third(Axis one, Axis two) {
        switch (one) {
            case X: {
                if (two == Y) {
                    return Z;
                }
                return Y;
            }
            case Y: {
                if (two == X) {
                    return Z;
                }
                return X;
            }
            case Z: {
                if (two == Y) {
                    return X;
                }
                return Y;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Axis getMirrorAxis(Mirror mirrorIn) {
        switch (mirrorIn) {
            case FRONT_BACK: {
                return X;
            }
            case LEFT_RIGHT: {
                return Z;
            }
        }
        return null;
    }

    public abstract Axis one();

    public abstract Axis two();

    public abstract Facing facing(boolean var1);

    public abstract double get(double var1, double var3, double var5);

    public abstract float get(float var1, float var2, float var3);

    public abstract int get(int var1, int var2, int var3);

    public abstract <T> T get(T var1, T var2, T var3);

    public abstract Direction.Axis toVanilla();
}

